import setuptools

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()
setuptools.setup(
    name="scVAR", 
    version="0.0.2",
    author="Ivan Merelli",
    author_email="ivan.merelli@itb.cnr.it",
    description="A tool to integrate genomics and transcriptomics in scRNA-seq data.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    packages=setuptools.find_packages(include=['scVAR', 'scVAR.*']),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    install_requires = [
	'numpy',
	'pandas',
	'scanpy',
	'torch',
	'umap',
        'leidenalg',
        'igraph',
	'anndata',
	'scikit-learn',
	'scipy',
        'matplotlib'
    ],
    python_requires='>=3.10',
)
