"""
scVAR package initialization
============================
Expose main analysis functions for transcriptomic and variant integration.
"""

from .scVAR import (
    transcriptomicAnalysis,
    variantAnalysis,
    calcOmicsClusters,
    weightsInit,
    save_all_umaps,
    omicsIntegration,
    pairedIntegrationTrainer,
    distributionClusters,
)

__all__ = [
    "transcriptomicAnalysis",
    "variantAnalysis",
    "calcOmicsClusters",
    "weightsInit",
    "omicsIntegration",
    "save_all_umaps",
    "pairedIntegrationTrainer",
    "distributionClusters",
]
