prefix <- format(as.Date(Sys.time()), "%Y%m%d")


basename <- '_bthalcombo_v6_preGT_plus_6x_healthy_'


basedir <- '.'


# -----------------------------------------------------------------------------------

library(Seurat)
library(future)

library(ggplot2)
library(cowplot)

suppressMessages(library(dplyr))


plan(strategy = "multicore", workers = 10)

options(future.globals.maxSize = +Inf) # (1024 * 32) * 1024^2 )


# -------------------------------------------------------------------------------------                         

data <- readRDS( paste0(basedir, '20230704_bthalcombo6_preGT_plus_6x_healthy_controls_counts_Seurat_obj.rds') )


s.genes <- cc.genes$s.genes
g2m.genes <- cc.genes$g2m.genes



Sys.time()
print("Preprocessing")

data.list <- SplitObject(data, split.by = "donor")


data.list <- lapply(X = data.list, FUN = SCTransform, vars.to.regress = c("nCount_RNA", "mitoc_fraction"), vst.flavor = "v2")

data.list <- lapply(X = data.list, FUN = CellCycleScoring, s.features = s.genes, 
                                                           g2m.features = g2m.genes, 
                                                           assay = 'SCT' )

data.list <- lapply(X = data.list, FUN = SCTransform, 
                                    vars.to.regress = c("nCount_RNA", "mitoc_fraction", 'S.Score', 'G2M.Score'), vst.flavor = "v2")


Sys.time()
print("Selecting features")
                                    
features <- SelectIntegrationFeatures(object.list = data.list, nfeatures = 3000)
data.list <- PrepSCTIntegration(object.list = data.list, anchor.features = features)



Sys.time()
print("Selecting anchors")

data.anchors <- FindIntegrationAnchors(object.list = data.list, 
                                       normalization.method = "SCT",
                                       anchor.features = features)
    
saveRDS(file = paste0(basedir, prefix, basename, 'SCT_anchors.rds'), data.anchors )


Sys.time()
print("Integrating datasets...")
    
data.combined.sct <- IntegrateData(anchorset = data.anchors, normalization.method = "SCT")

Sys.time()

saveRDS(file = paste0(basedir, prefix, basename, 'SCT_integrated.rds'), data.combined.sct )


Sys.time()
