# run each individual library on cellranger

module load cellranger/6.0.1

ref=refdata-cellranger-hg19-3.0.0

cellwrangler () {

  echo "Started processing library ${library[$1]} on `date`"

  cellranger count --id=${library[$1]} \
                   --sample=${library[$1]} \
                   --transcriptome=${ref} \
                   --fastqs=${fastqdir}

  echo "Finishing processing library ${library[$1]} on `date`"

}


# Demux donors in donor-multiplexed samples (libraries: SITTB3, SITTC3, SITTG3, SITTE10, SITTF10)

# adjusts the barcode suffix "-1" to "-1-0" and "-1-1" respectively to match suffixes added by scanpy
adjustbam () {

  echo "Starting processing INPUT sample ${libs[$1]} on `date`"
  
  let suffix=$1-1
  singularity exec ${tooldir}souporcell.sif samtools view -h ${basepath}${libs[$1]}/outs/possorted_genome_bam.bam \
                                                    | sed -r "s/(CB:Z:[ACTG]+\w+-1)/\1-${suffix}/" | \
                                                    singularity exec ${tooldir}souporcell.sif \
                                                    samtools view -@ ${SLURM_NTASKS} -bSh - > ${basepath}temp/${libs[$1]}_adjusted.bam
                                                    
  echo "Finished processing INPUT sample ${libs[$1]} on `date`"  
}


# How many donors/genotypes are present in the sample to demux
ndonors=2


# demultiplex donors using souporcell
demux () {

  echo "Started processing library $lib on `date`"

  singularity exec ${tooldir}souporcell.sif souporcell_pipeline.py \
    -i ${workdir}processed/temp/${libs[$1]}_adjusted.bam \
    -b ${workdir}notebooks/output/${libs[$1]}_filtered_barcodes.txt \
    -f ${basedir}references/10x/cellranger3x/refdata-cellranger-hg19-3.0.0/fasta/genome.fa \
    -o ${workdir}processed/souporcell/${libs[$1]} \
    -t ${SLURM_NTASKS} \
    -k ${ndonors}

   echo "Finished processing library $lib on `date`"	
    
}
