# Lidonnici_NatureComm2025

This repository includes data analysis workflow and source code for reproducing figures embedded in the following manuscript:  

Maria Rosa Lidonnici, Giulia Chianella, Nicole Mende et al. **Imbalanced TGF-beta signalling and autophagy drive erythroid priming of hematopoietic stem cells in Beta-thalassemia.**  

## Abstract
The hematopoietic stem cell and multipotent progenitor (HSC/MPP) pool dynamically responds to stress to adapt blood output to specific physiological demands. In beta-thalassemia (Bthal), the severe anemia and the ineffective erythropoiesis generate expansion of erythroid precursors and a chronic stress status in the bone marrow (BM) microenvironment. However, the response to the BM altered status at the level of the HSC/MPP compartment in terms of lineage commitment has not been investigated. Bulk and single-cell RNA-sequencing reveal that Bthal HSCs/MPPs are expanded and activated with an enhanced priming along the whole Ery differentiation trajectory. Consistently, HSC/MPP showed an altered TGFβ expression and autophagy transcriptional signatures along with a declined dormancy state. We discovered that the altered TGF-beta signalling fosters the Ery potential of HSCs by reducing their autophagic activity and in vivo stimulation of autophagy is sufficient to rescue the imbalance of the HSC compartment. Our findings identify the interplay between TGFß and HSC autophagy as a key driver in the context of non-malignant hematopoiesis.  

## Raw data 

### bulk RNAseq
Human bulk RNAseq have been deposited in the GEO repository with accession number [GSE263306](https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE263306), whereas bulk RNAseq data on sorted murine HSCs are deposited in European Nucleotide Archive database with accession number [PRJEB31882](http://www.ebi.ac.uk/ena/data/view/PRJEB31882). 

### scRNAseq 

Gene expression scRNA-seq data have been deposited in the GEO repositories with accession numbers [GSE247738](https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE247738) for the samples P185, P257 and P185 (GSM7900108, GSM7900109 and GSM7900110 respectively) and [GSE263204](https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE263204) for the samples HD, B10059062019, B10060062019, B60041052018, B60166112019, B60133072019, B60170112019).

## Data analysis workflows and figure scripts

Scripts and inputs are organized in two folders: [bulkRNAseq](http://www.bioinfotiget.it/gitlab/custom/lidonnici_naturecomm2025/-/tree/main/bulkRNAseq) and [scRNAseq](http://www.bioinfotiget.it/gitlab/custom/lidonnici_naturecomm2025/-/tree/main/scRNAseq).  Each folder has its own readme with content description.

