# Fiumara_BasePrimeEd2022_NHEJ

Fiumara M, Ferrari F, Omer-Javed A, Beretta S et al.
**Genotoxic effects of base and prime editing in human hematopoietic stem cells.**
_Nature Biotechnology_ 2023.
- PMID: [37679541](https://www.ncbi.nlm.nih.gov/pubmed/37679541)
- DOI: [10.1038/s41587-023-01915-4](https://doi.org/10.1038/s41587-023-01915-4)
- NHEJ Base Editing: [GSE220763](https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE220763)
- NHEJ Base Editing (multi-locus): [GSE239852](https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE239852)
- NHEJ Prime Editing: [GSE220765](https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE220765)

---

### Analyses ###

Sequencing data were analyzed with [_CRISPResso2_](https://github.com/pinellolab/CRISPResso2).
- Pre-processing options: `–trim_sequences –trimmomatic_command trimmomatic –trimmomatic_options_string ’ILLUMINACLIP:TruSeq3-PE-2.fa:2:30:10 MINLEN:100’` to get rid of low-quality positions (score < 30) and to remove Illumina adapters, keeping only trimmed sequences longer than 100bp
- Sequences were mapped to the input amplicon reference and the quantification window was set to 1bp around the cut site, as identified by providing the gRNA sequence. Computed alleles were quantified by measuring the number of reads and their relative abundance based on total read counts.
- Base editing options: `--base_editor_output --conversion_nuc_from <T/G> --conversion_nuc_to <C/A>` to measure the frequency of the expected nucleotide substitutions for the specific BE
- Prime editing options the sequences for the pegRNA spacer, extension and scaffold, as well as for the additional nicking gRNA and the reference amplicon, were provided as input to identify and quantify precise prime editing (i.e., carrying only the expected edit), imprecise prime editing (i.e., containing the prime editing and additional modifications, such as partial scaffold-incorporation and indels) and other events.

CRISPResso2 output alleles were post-processed by correcting all the mismatch positions outside the quantification window and re-quantifying the total read counts and consequently the corresponding relative abundances.
