filter_variants_v3 <- function(infile, sampleid = "Sample01", dp = 50){
  
  library(openxlsx)
  
  df <- read.table(file = infile, sep = "\t" ,header = T, stringsAsFactors = F)
  write.xlsx(x = df, file = paste0(sampleid,"_full_variants_annotated.xlsx"), asTable = T)
  
  colnames(df) <- c("Chromosome","Position","Reference","Alternative","AF","DP","AD.R","AD.A","GT","ID","FILTER","HGVS_P","Gene","Biotype",
                    "Rank","Effect","Impact","Common","G5",colnames(df)[20:35])
  
  df$Common[is.na(df$Common)] <- 0 
  df <- subset.data.frame(x = df, subset = DP > dp & Common == 0 & 
                            Biotype == "protein_coding" & !Impact %in% c("LOW", "MODIFIER") 
                          )

  df$sampleid <- sampleid
  df$variantkey <- paste(df$Chromosome, df$Position, df$Reference, df$Alternative,sep = "_")
  write.xlsx(x = df, file = paste0(sampleid,"_rawvariants_dp_",dp,"_coding_lowimpact_notcommon",".xlsx"), asTable = T)
  return(df)
}
