## Introduction

**scRNAseq** analysis was performed using a standard pipeline that includes the following steps:

Most of the single-cell RNAseq analyses were performed with [Seurat](https://satijalab.org/seurat/).  
Below the main steps of the basic data analysis workflow that start from a minimal object after loading of 10X data to markers identification:  

1. Normalization (default seurat settings)
2. Scaling (with following variables to regress out: percent.mt + nCount_RNA and CC.Difference calculated as show in [vignette](https://satijalab.org/seurat/articles/cell_cycle_vignette.html#alternate-workflow-1))
3. Dimensionality reduction: PCA
4. Harmony batch removal (patientID - only for integrated analysis with all Diagnoses)
5. Clustering
6. Markers identification (different resolution according to datasets / subsets)
7. Evaluation of signatures according to module score (AddModuleScore function - default settings)

Data analysis was performed both at single and integrated level.  
Parameters and metrics are described in supplementary tables.  
Raw counts and complete metadata can be found on GEO repository [GSE236136](https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE236136).  
Seurat objects for each disease are also available in seurat_objects folder for convenience.



