# miR-126 and minimal residual disease in B-ALL

Complete elimination of B-cell acute lymphoblastic leukemia (B-ALL) by a risk-adapted primary treatment approach remains a clinical key objective, which fails in up to a third of patients. Recent evidence has implicated subpopulations of B-ALL cells with stem-like features in disease persistence. We hypothesized that microRNA-126, a core regulator of hematopoietic and leukemic stem cells, may resolve intra-tumor heterogeneity in B-ALL and uncover therapy-resistant subpopulations. We exploited patient-derived xenograft (PDX) models with B-ALL cells transduced with a miR-126 reporter allowing the prospective isolation of miR-126(high) cells for their functional and transcriptional characterization. Discrete miR-126(high) populations, often characterized by MIR126 locus de-methylation, were identified in 8/9 PDX models and showed increased repopulation potential, in vivo chemotherapy resistance and hallmarks of quiescence, inflammation and stress-response pathway activation. Cells with a miR-126(high) transcriptional profile were identified as distinct disease subpopulations by single cell RNA sequencing in diagnosis samples from adult and pediatric B-ALL. Expression of miR-126 and locus methylation were tested in several pediatric and adult B-ALL cohorts, which received standardized treatment. High microRNA-126 levels and locus de-methylation at diagnosis associate with sub-optimal response to induction chemotherapy (MRD > 0.05% at day +33 or MRD+ at day +78).

# Code and workflows

This repository is structured in different folders according to the different omics covered in the paper.  
The main categories are:  

- scRNAseq
- BulkRNAseq
- Methylation
- Whole Exome Sequencing

Each folder will include a bried description of the main data analysis steps and the most important scripts used for producing data present in the 
manuscript.  



