#  GGridges

library(DESeq2)
library(ggplot2)
library(openxlsx)
library(pheatmap)
library(RColorBrewer)
library(clusterProfiler)
library(DOSE)          
library(AnnotationHub)
library(org.Hs.eg.db)
library(gridExtra)

gsea_res_interaction <- gsea_res # from interaction analysis script
gsea_bulk <- readRDS(file = "Hallmark_GSEA.rds")
gsea_res <- gsea_bulk

a <- ridgeplot(gsea_res$GFP_L_vs_GFP_H, fill = "NES", 
               showCategory = nrow(gsea_res$GFP_L_vs_GFP_H@result[gsea_res$GFP_L_vs_GFP_H@result$p.adjust < 0.2,])) + 
  scale_fill_gradient2(low = "#0066E7", high= "#D4070F") + 
  ggtitle("miR-126 High vs miR-126 Low") + #, subtitle = "Human dataset") +
  xlab("logFC") +
  theme(legend.position = "none", plot.margin=unit(c(0.5,0.5,0.5,0.5), 'cm'))
a$theme$axis.text.y$size <- 8
a$theme$axis.text.x$size <- 8
a$theme$axis.title.x$size <- 10

a_2 <- a

a_2$data$category <- gsub(a$data$category, pattern = "HALLMARK_", replacement = "")
a_2$data$category <- factor(x = a_2$data$category, 
                            levels = gsub(x = levels(a$data$category), replacement = "", pattern = "HALLMARK_"))

b <- ridgeplot(gsea_res$data_OE_vs_SM, fill = "NES", 
               showCategory = nrow(gsea_res$data_OE_vs_SM@result[gsea_res$data_OE_vs_SM@result$p.adjust < 0.2,])) + 
  scale_fill_gradient2(low = "#0066E7", high= "#D4070F") + 
  ggtitle("miR-126 OE vs miR-126 SM") + #, subtitle = "Murine dataset") +
  xlab("logFC") + 
  theme(legend.position = "none", plot.margin=unit(c(0.5,0.5,0.5,0.5), 'cm'))
b$theme$axis.text.y$size <- 8
b$theme$axis.text.x$size <- 8
b$theme$axis.title.x$size <- 10

b_2 <- b

b_2$data$category <- gsub(b$data$category, pattern = "HALLMARK_", replacement = "")
b_2$data$category <- factor(x = b_2$data$category, 
                            levels = gsub(x = levels(b$data$category), replacement = "", pattern = "HALLMARK_"))

c <- ridgeplot(gsea_res_interaction, fill = "NES", 
               showCategory = nrow(gsea_res_interaction@result[gsea_res_interaction@result$p.adjust < 0.2,])) +
scale_fill_gradient2(low = "#0066E7", high= "#D4070F") + 
  ggtitle("Interaction miR-126 lvl - Treatment") + 
  xlab("logFC") + 
  theme(legend.position = "none", plot.margin=unit(c(0.5,0.5,0.5,0.5), 'cm'))
c$theme$axis.text.y$size <- 8
c$theme$axis.text.x$size <- 8
c$theme$axis.title.x$size <- 10

c_2 <- c 

c_2$data$category <- gsub(c$data$category, pattern = "HALLMARK_", replacement = "")
c_2$data$category <- factor(x = c_2$data$category, 
                            levels = gsub(x = levels(c$data$category), replacement = "", pattern = "HALLMARK_"))

# Panel 

png(filename = "Panel_gsea_hallmakrs_nes_distribution.png", width = 18, height = 6, units = "in", res = 300)
grid.arrange(a_2,b_2,c_2,widths = c(0.30,0.30,0.35), ncol = 3)
dev.off()

svg(filename = "Panel_gsea_hallmakrs_nes_distribution.svg", width = 18, height = 6)
grid.arrange(a_2,b_2,c_2,widths = c(0.30,0.30,0.35), ncol = 3)
dev.off()


