library(openxlsx)
library(dplyr)
library(ggplot2)
library(openxlsx)

full.t <- read.xlsx("NHEJ_Alleles_corr_thr0.2.xlsx")
head(full.t)
tt <- full.t %>% filter(is.na(Ref)) %>% group_by(Sample, Group, Treatment) %>% summarise(PercModif = sum(perc_reads))
ttref <- full.t %>% filter(Ref == "*" &Group != "OT3_R1") %>% group_by(Sample, Group, Treatment) %>% summarise(PercRef = sum(perc_reads))
tt <- merge(tt, ttref, by = c("Sample", "Group", "Treatment"), all = T)
tt$Tot <- tt$PercModif + tt$PercRef
tt$PercModif[is.na(tt$PercModif)] <- 0
tt$Group <- factor(tt$Group, levels = c("A", "B1", "B2", "Tigit", "OT1", "OT2", "OT3", "OT4", "OT5", "OT6", "OT7", "OT8"))
head(tt)


p <- ggplot(tt, aes(x = Treatment, y = PercModif, color = Treatment)) +
    theme_bw(base_size = 13) +
    theme(axis.text.x = element_text(angle = 45, hjust = 1),
          legend.position = "none") +
    geom_jitter(size = 2, alpha = .6, width = .4) +
    scale_color_brewer(palette = "Set1") +
    ylab("Sum % Modif.") +
    scale_y_continuous(n.breaks = 10) +
    facet_grid(.~Group)
p
